# HBuilder X - Release Notes
======================================
## 3.7.9.20230324
* Fixed the bug that HBuilderX crashes when you right-click the schema.json file in 3.7.8 to download DB Schema

## 3.7.8.20230323
### HBuilder
* Added a built-in formatting plug-in, which supports the use of the .jsbeautifyrc configuration file under the project [Details](https://hx.dcloud.net.cn/Tutorial/extension/js-beautify)
* Fixed the bug that the built-in formatting plug-in does not support formatting the ts code in the Vue file.
* Language Server: Fixed Vue file `this.xxx = ...`, xxx cannot go to the defined bug.
* Language Server: Fixed the uni-app cli ts project, after using pnpm to install the module, opening the vue file under the project causes the language service to crash.
* Fixed the bug that the language service ts file in some cases, the ts grammar check does not take effect
* Optimize settings, language service configuration, enable code assistant, after modifying configuration items, it will take effect without restarting HBuilderX
* Fixed Enable .editorconfig support, when configuring `insert_final_newline`, accidentally touch the bug of the code assistant when saving
* Fixed Enable .editorconfig support, if the last line of the Vue file does not wrap, the bug that the file content will be wrong when saving
* Fixed MacOSX, run the App to iOS, the device selection window, in some cases, the bug that the iOS device is repeatedly displayed
* Added uni-app uts plug-in to run to iOS to support debugging (requires MacOSX) [Details](https://uniapp.dcloud.net.cn/tutorial/debug/uni-uts-debug-ios.html)
## uni-app plugin
* Web、App Fixed NodesRef cannot get properties [Details](https://ask.dcloud.net.cn/question/163535)
* Web Fixed The markertap event will be triggered when the Gaode map is zoomed [Details](https://ask.dcloud.net.cn/question/162763)
* App Updated The video component supports the isLive property
* App Fixed uni.uploadFile interface timeout configuration is invalid [Details](https://ask.dcloud.net.cn/question/163747)
* App Fixed onPageScroll and onReachBottom are invalid when the Vue2 project uses the composition API [Details](https://ask.dcloud.net.cn/question/162503)
* App-Android Fixed Using Secure Network may cause a crash on some devices
* App-iOS Fixed The nvue page component may occasionally crash when setting the border style [Details](https://ask.dcloud.net.cn/question/164236)
* App-iOS Fixed The nvue page loading component event does not fire properly [Details](https://ask.dcloud.net.cn/question/163143)
* Mini Program Fixed In some cases of Vue2 projects, v-for nested v-model is invalid after compilation
* JingDong Mini Program Added Support compiling Vue3 projects [Details](https://github.com/dcloudio/uni-app/pull/4023)
* Weixin Mini Program Added Support Skyline gesture [Details](https://ask.dcloud.net.cn/question/162700)
* Weixin Mini Program Fixed Some attributes of components such as share-element are invalid. [Details](https://ask.dcloud.net.cn/question/163926)
* Alipay Mini Program Fixed Vue3 project page-meta component page-style attribute is invalid. [Details](https://ask.dcloud.net.cn/question/163563)
* ByteDance Mini Program Fixed uni.chooseImage does not support sizeType configuration. [Details](https://ask.dcloud.net.cn/question/163986)
### uniCloud plugin
* [Important] Added uni facial recognition verify. All-in-one financial-grade security in the cloud [Details](https://uniapp.dcloud.net.cn/uniCloud/frv/intro)
* [Important] uni-id-pages adds real-name authentication function [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#frv)
* [Important] Added uni-frv-external cloud-integrated template for non-uniCloud business to use the real-name authentication function [Details](https://uniapp.dcloud.net.cn/uniCloud/frv/dev.html#uni-frv-external)
* Added The uni-cloud-s2s public module is added to solve the problem of mutual trust between the uniCloud and the traditional server [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-cloud-s2s.html)
* Fixed uniCloud HBuilderX plugin In some cases, modifying a JS file does not take effect in real time
* Fixed uniCloud HBuilderX plugin In some cases, modifying dependencies of cloudfunction causes package.json content error [Details](https://ask.dcloud.net.cn/question/165273)
* Updated Secure Network The WeChat Mini Program allows secure network handshake without calling the uni-id-co method [Details](https://uniapp.dcloud.net.cn/uniCloud/secure-network.html#mp-weixin-without-uni-id-pages)
* Updated uniCloud HBuilderX plugin When you call a local cloudfunction, each project fixes 4 cloudfunction instances to a minimum of 2 instances and a maximum of 8 instances
* Updated uniCloud HBuilderX plugin Call local cloudfunction stop waiting for instances to be idle when all instances are occupied, and directly reject the call request
* Updated Aliyun The maximum timeout for client connection to cloudfunction is adjusted from 20 seconds to 40 seconds
* Updated Aliyun The QPS limit of http trigger through default domain is adjusted from 100 to 1000
* Updated Aliyun The limit for CDN refreshes for front-end web hosting has been adjusted from 3/h to 10/h
* Fixed Aliyun The limit of collection number cannot be refreshed in real time after collection is removed
* Fixed Aliyun Some transaction errors are not clearly reported
* Updated When the client SDK is developing and debugging, the time of connecting to the local network is adjusted from the connection when the application is started to the connection when the local SCF is accessed
* Fixed The client sdk uniCloud.init and uniCloud.database methods still use the public beta endpoint by default when associating with the official version of aliyun space
### App plugin (5+ App & uni-app)
* Android Fixed The readAsDataURL of plus.io.FileReader returns base64 characters containing line breaks [Details](https://ask.dcloud.net.cn/question/164955)
* Android Fixed tabbar page switching may be unexpected in dark mode [Details](https://ask.dcloud.net.cn/question/163416)
* Android Fixed In Xiaomi Android 13 devices, selecting pictures from the album may be abnormal caused by version 3.7.3 [Details](https://ask.dcloud.net.cn/question/163903)
* iOS Fixed The video controls setting to false does not hide the title bar when displayed in full screen [Details](https://ask.dcloud.net.cn/question/160712)

## 3.7.3.20230223
### HBuilder
* Add code block surround, wrap code blocks such as if outside the selection area (menu Edit->Surround->Code block surround, shortcut key win: `Ctrl+Alt+T`, mac: `Command+Alt+T`). [Details](https://hx.dcloud.net.cn/Tutorial/Language/Snippets?id=surround)
* Added project manager, font size adjustment (menu settings-> Commonly Used). [Details](https://hx.dcloud.net.cn/Tutorial/setting?id=project-explorer-font-size)
* Language Server: Fixed Vue3-ts project, the bug that the image src attribute reports an error [Details](https://ask.dcloud.net.cn/question/162064)
* Language Server: Fixed uni-app main.js, the Vue variable or method defined by Vue.prototype.xxx, in the vue file, `this.` cannot prompt Bug. [Details](https://ask.dcloud.net.cn/question/147190)
* Language Server: Fixed the Vue file, when there are only script and style nodes, but no template node, the document structure diagram shows a blank bug.
* Fixed the bug that multiple lines of content will be copied when copying or cutting when multiple cursors are on the same line.
* Fixed the bug that it may not be possible to go to the definition when it takes a long time to go to the definition.
* Fixed the bug that HBuilderX cannot be started due to abnormal editor theme configuration in some cases.
* Fixed the bug that blank characters cannot be highlighted in the Markdown code area.
* Fixed the bug that Markdown copied table data from WPS and pasted it as a Markdown table syntax conversion error.
* Fixed the bug that the editor will not automatically scroll to the original cursor position when you press the esc key to find symbol in Editor.
* Fixed the setting interface and manifest.json interface, clicking the blank area on the right side of the text on the check box control will also cause the bug to be selected/cancelled.
* uniCloud: Fixed the bug that the upload and run operation fails when there are Chinese files in the cloud function directory of uniCloud cloud function.
* Mobile App Playground: MacOSX run the project to the real iOS device, and automatically start the App (MacOSX needs to install Xcode that matches the iOS mobile phone system) [Details](https://uniapp.dcloud.net.cn/tutorial/run/run-app.html#ios-app-automatically-open)
* Mobile App Playground: Added Windows operating system, iOS standard base, supports signing with Apple certificate, after signing, it can run standard base to iOS real device [Details](https://uniapp.dcloud.net.cn/tutorial/run/ios-apple-certificate-signature.html)
* Mobile App Playground: Added Windows device selection window, custom dock and standard dock support switching with & shortcut keys.
* uni-app: Added WeChat Build, automatically uploaded to the WeChat platform, and supports the configuration of WeChat ci robot numbers. [Details](https://uniapp.dcloud.net.cn/tutorial/build/publish-mp-weixin-cli.html)
* uni-app: uts plug-in run to Android support debug debugging. [Details](https://uniapp.dcloud.net.cn/tutorial/debug/uni-uts-debug.html)
* uni-app: Optimize uts plugin, iOS compilation, improve compilation speed.
* uni-app: Fixed the bug that when uni-app runs to Chrome, it opens a new Chrome instance every time it runs.
### uni-app plugin
* [Important] Added uts components. Native extensions can be developed using the uts language. [Details](https://uniapp.dcloud.net.cn/plugin/uts-component.html)
* Added uni-vue-devtools plugin. Easy to view, modify data and review custom components. [Details](https://uniapp.dcloud.net.cn/tutorial/debug/uni-vue-devtools.html)
* Fix the variable conditions in the Vue3 project uni.scss to compile the invalid bug. [Details](https://ask.dcloud.net.cn/question/162271)
* Web, App Added The page-meta component supports the scroll-top property.
* Web Fixed The show-progress attribute of the video component does not take effect. [Details](https://github.com/dcloudio/uni-app/issues/3908)
* Web Fixed When the input component type=digit, the placeholder is not displayed after clearing the input box. [Details](https://ask.dcloud.net.cn/question/160726)
* Web Fixed Vue3 project onNavigationBarSearchInputConfirmed not working. [Details](https://ask.dcloud.net.cn/question/154740)
* Web Fixed Vue3 project switching tabbar page does not trigger onTabItemTap.
* Web Fixed The title bar button text shows the abnormal bug after internationalization. [Details](https://ask.dcloud.net.cn/question/162369)
* Web Fixed Vue3 project the bug that the picker got stuck after packaging. [Details](https://ask.dcloud.net.cn/question/162091)
* Web Fixed Vue2 project the bug that the built-in browser Gaode map uni.getLocation reports an error. [Details](https://ask.dcloud.net.cn/question/156303)
* App Added [ext component] animation-view component. [Details](https://uniapp.dcloud.net.cn/component/animation-view.html)
* App Fixed Vue3 project the bug that the color of custom buttons does not change when sliding to the top of the navigation bar when the native navigation bar type is transparent. [Details](https://ask.dcloud.net.cn/question/154074)
* App Fixed Vue3 project the bug that the height of the movable area will not be updated after the movable-area component changes its height. [Details](https://ask.dcloud.net.cn/question/159723)
* App Fixed Vue3 project the bug that the preloadPage life cycle triggers an exception. [Details](https://ask.dcloud.net.cn/question/160416)
* App-Android Fixed The uni.sendSocketMessage introduced by the 3.6.16 upgrade fastjson cannot send ArrayBuffer data. [Details](https://ask.dcloud.net.cn/question/161872)
* App-Android Fixed The height of the cell component of the nvue page exceeds the height of the list itself, and the loadmore event is frequently fired. [Details](https://ask.dcloud.net.cn/question/161972)
* App-Android Fixed After the placeholder attribute of the input component of the nvue page is changed, the placeholder-style and placeholder-class properties are invalidated. [Details](https://ask.dcloud.net.cn/question/161678)
* App-Android Fixed The bubble displays abnormally when the marker of the nvue page map component sets the anchor. [Details](https://ask.dcloud.net.cn/question/161180)
* App-Android Fixed The cover-view is not displayed when the nvue page map component updates the marker. [Details](https://ask.dcloud.net.cn/question/161998)
* App-Android Fixed uni.getSystemInfo may get the same deviedId value on some devices. [Details](https://ask.dcloud.net.cn/question/163174)
* Weixin Mini Program Added pages.json supports configuring the entryPagePath property. [Details](https://ask.dcloud.net.cn/question/126216)
* Mini Program Fixed Vue3 project Fixed the bug that the page is referenced as a component and the title configuration of the navigation bar is invalid. [Details](https://ask.dcloud.net.cn/question/162745)
* Mini Program Fixed In some cases of Vue2 projects, v-for nested v-model is invalid after compilation.
* Weixin Mini Program Fixed Incorrect return value when using uni.env in Vue2 project. [Details](https://ask.dcloud.net.cn/question/159865)
* Alipay Mini Program Fixed The DingTalk mini program uses uni.saveImageToPhotosAlbum to report an error. [Details](https://ask.dcloud.net.cn/question/159183)
* Alipay Mini Program Fixed the bug that the platform attribute returned by uni.getSystemInfo is incorrect in the simulator.
* QQ Mini Program Vue3 project Fixed the bug that the video component ended event does not trigger on the real device. [Details](https://ask.dcloud.net.cn/question/155602)
* Kuaishou Mini Program Vue3 project Fixed the bug that the project button getPhoneNumber triggers an exception. [Details](https://ask.dcloud.net.cn/question/4113)
* uts plugin App Added Math related function support.
* uts plugin App-Android Fixed Array.sort function does not work.
* uts plugin App-iOS Added Support calling .a static library. [Details](https://uniapp.dcloud.net.cn/plugin/uts-plugin.html#ios-libs)
* uts plugin App-iOS Fixed Incorrect formatting when using multiple levels of nested complex objects
* uts plugin App-iOS Fixed The function may be abnormal when the parameter is greater than the actual number when calling the method
* uts plugin App-iOS Fixed The initial value of the property does not take effect after the component is hot refreshed
### uniCloud plugin
* Added Manage dependencies of schema extension [Details](https://uniapp.dcloud.net.cn/uniCloud/jql.html#deps-of-jql)
* Added JQL Trigger method add new parameters [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#trigger-param)
* Fixed Using array which contains negative value in parameter of where method report an error [Details](https://ask.dcloud.net.cn/question/161852)
* Fixed Calling cloud object method without return value report an error [Details](https://ask.dcloud.net.cn/question/161852)
* Updated Deprecate subCollection property of JQL triggr parameter, please use secondaryCollection instead [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#trigger-param)
* Added New JQL trigger timing "beforeReadAsSecondaryCollection" and "afterReadAsSecondaryCollection" [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#trigger-timing)
* Aliyun Fixed No error message was returned when deleting file encounter error
* HBuilderX Plugin Fixed Using console.warn output message to console panel in cloud functions was not colored properly
### App plugin (5+ App & uni-app)
* Android Fixed Picture selection on Android 13 devices prompts no permission [Details](https://ask.dcloud.net.cn/question/160879)
* Android Fixed plus.io.FileReader's readAsDataURL reads data without splitting by slice position [Details](https://ask.dcloud.net.cn/question/160467)
* Android Fixed The VideoPlayer fires the timeupdate event when the video is buffered
* Android Update PayPal SDK to version 0.8.8 to fix the bug that payment cannot be made normally [Details](https://ask.dcloud.net.cn/question/154976)
* Android Fixed plus.downloader.clear cannot clear persistent storage downloads [Details](https://ask.dcloud.net.cn/question/162099)
* iOS Fixed AudioPlayer seekTo does not support milliseconds to jump to the specified position

## 3.6.18.20230117
### uni-app plugin
* Web Fixed The Vue3 project scroll-view component slot introduced in version 3.6.17 renders abnormally in some cases [Details](https://ask.dcloud.net.cn/question/149557)
* Weixin Mini Program Fixed An error is reported when running the enterprise version of WeChat introduced by version 3.6.17
* Weixin Mini Program Fixed Version 3.6.17 introduced Vue2 project partially in the scope slot access length property reported an error
### App plugin (5+ App & uni-app)
* Android Fixed The system navigation bar button color is the same as the background color caused by version 3.6.17 [Details](https://ask.dcloud.net.cn/question/161501)

## 3.6.17.20230112
* Fixed HBuilderX green soft theme, select the terminal text, the bug that the selected color is not displayed.
* Optimize one-click sharing of Markdown, css and js resources required by the webpage, and upload them to uniCloud web page hosting.
* Fixed the bug that the uni-app runs to the iOS simulator, and the uni debugging is turned on. After opening, the window shows a blank bug
### uni-app plugin
* App-Vue, Web Updated The input component supports the inputmode property [Details](https://uniapp.dcloud.net.cn/component/input.html#inputmode)
* App Fixed The Vue3 project image component uses base64 to display exceptions [Details](https://ask.dcloud.net.cn/question/158368)
* App-Android Fixed The live-pusher component of the nvue page refuses the camera permission and then manually opens it. After returning to the application, the camera preview may not be called [Details](https://ask.dcloud.net.cn/question/158518)
* App-iOS Fixed After the nvue page map component uses a custom map style, switching satellite images is invalid [Details](https://ask.dcloud.net.cn/question/159316)
* App-iOS Fixed Start the application with a white screen after using the simulator to enable debugging [Details](https://ask.dcloud.net.cn/question/160363)
* Web Fixed The input component enters a negative number to bring out the last result [Details](https://ask.dcloud.net.cn/question/159447)
* Web Fixed Using uni.navigateTo eventChannel in Vue3 project will only be called once [Details](https://ask.dcloud.net.cn/question/155922)
* Web Fixed Vue3 project scroll-view component scrolling frequently triggers view updates [Details](https://ask.dcloud.net.cn/question/149557)
* Web Fixed The Vue3 project uses the picker component end attribute to read errors [Details](https://github.com/dcloudio/uni-app/issues/4075)
* Web Fixed uni.setTabBarItem causes tab switching life cycle exception [Details](https://ask.dcloud.net.cn/question/160739)
* Weixin Mini Program Fixed Array length changes cannot be observed in the Vue2 project template [Details](https://github.com/dcloudio/uni-app/issues/1827)
* Alipay Mini Program Fixed Vue3 project use inline styles running error report [Details](https://ask.dcloud.net.cn/question/159362)
### uniCloud plugin
* JQL Fixed Trigger report an error when using setUser without permission parameter
* JQL Fixed Add method report an error when using null in child object
* JQL Added Add triggerContext parameter to share variable between before trigger and after trigger [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#trigger-context)
* Aliyun Updated Single file size limit was changed from 100MB to 5GB
### App plugin (5+ App & uni-app)
* Android Fixed Multiple calls to createBLEConnection to connect to a Bluetooth device, failure to connect the device may also trigger a success callback [Details](https://ask.dcloud.net.cn/question/113070)
* iOS Fixed The iconWidth/iconHeight property is disabled when plus.nativeUI.toast sets style to inline [Details](https://ask.dcloud.net.cn/question/160192)
* iOS Fixed startBluetoothDevicesDiscovery Search for nearby Bluetooth devices returns data without an advertisData field [Details](https://ask.dcloud.net.cn/question/160178)

## 3.6.15.20221228
### HBuilder
* Language Server: Fixed the bug that the uni-app Vue file cannot be prompted for conditional compilation in the script tag [Details](https://ask.dcloud.net.cn/question/159783)
* Fixed the bug that in some cases, the .hbuilderx/launch.json file in the project root directory repeatedly writes data and reads and writes frequently, causing the editor to freeze
* Fixed the bug that the uni-app Vue3 runs to the browser, the browser Devtools console, and the log path shows errors
* Fixed the bug that the directory is incorrect after the uni_modules plugin is right-clicked to update the cli project
### uniCloud plugin
* JQL Fixed "clientInfo" field is missing in trigger paramter when triggered by using jql in trigger
* JQL Fixed Count trigger could not trigger by getCount
* JQL Fixed "where" is not null in parameter of trigger when using query without where
### uni-app plugin
* Mini Program, Web Fixed Unstable Bug in uni-push2.0 [Details](https://ask.dcloud.net.cn/question/159690?item_id=224222&rf=false)
### App plugin (5+ App & uni-app)
* Android Fixed Selecting files from system album may crash on some Harmony devices caused by version 3.6.13 [Details](https://ask.dcloud.net.cn/question/159556)
* Android Fixed Setting the targetSdkVersion value greater than or equal to 30 causes the app to crash when using AMap [Details](https://ask.dcloud.net.cn/question/159801)

## 3.6.14.20221215
### HBuilder
* Fixed the bug caused by HBuilderX3.6.13 that in some cases, the cursor position is wrong after the editor is pressed.
* Fixed the bug that the html file exported by HBuilderX3.6.13 runs to Chrome and starts a new Chrome instance.
* Fixed the bug caused by HBuilderX3.6.13 that in some cases, where the project root generated a 1.text test file.
### uni-app plugin
* App Fixed The startup debugging tool introduced by version 3.6.13 reports an error [Details](https://ask.dcloud.net.cn/question/159523)
* App-Android Fixed After using the canvas module, the wgt upgrade prompt that the canvas module is not configured [Details](https://ask.dcloud.net.cn/question/159283)
* Mini Program Fixed Version 3.6.13 introduces an error after using async/await to run [Details](https://ask.dcloud.net.cn/question/159413)
* uts plug-in App-Android platform fixes the bug of compiling errors when the regular expression contains escape characters
### uniCloud plugin
* Fixed the bug caused by HBuilderX 3.6.13, the debugging and running of cloud functions, and the Bug that cannot be debugged by Debug breakpoint.
* JQL Added `userInfo` and `result` to trigger parameter [userInfo](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#user-info)、[result](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#result)
* JQL Added `isEqualToJql` method to compare jql command [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#is-equal-to-jql)
* JQL Updated Ignore null value of complex type (file, array, object) field
* HBuilderX Plugin Fixed Local cloud function server failed to start in some old operating systems [Details](https://ask.dcloud.net.cn/question/159343)

## 3.6.13.20221209
* Upgrade HBuilderX built-in Node version to 16.17.0 and built-in npm version to 6.14.12
* Git plug-in: git pull operation, Git message status bar, added log view function.
* HBuilderX Settings: Aggregate language service-related configurations into the Language Service Configuration configuration item.
* Added Node debugging, which supports attaching breakpoint debugging to the already started node process. [Details](https://hx.dcloud.net.cn/Tutorial/extension/node-development?id=attach)
* Added MarkDown, support for Mermaid diagrams, such as flow charts [Details](https://hx.dcloud.net.cn/Tutorial/Language/markdown?id=mermaid)
* Added MarkDown, code area, kotlin and uts with code highlighting support
* Added MarkDown, `! []()` and `[]()` syntax, support prompt file path [Details](https://hx.dcloud.net.cn/Tutorial/Language/markdown?id=PathHints)
* HBuilderX: Fixed a Bug where the language service process would not exit when HBuilderX exits abnormally
* HBuilderX: Windows, pop-up prompts when the Node process is intercepted by security software, causing Node plug-ins such as language services to fail to start.
* HBuilderX: Fixed the bug that some plug-in functions will fail when closing the new HBuilder window or dragging the tab to create a new window.
* Language Server: Fixed a Bug where the image path prompt failed when an unsupported image format existed
* Language Server: Fixed a Bug where space was added to the first line of formatted ts files for MacOSX
* Language Server: Fixed the bug that the uni-app pages.json usingComponents code hints the typo [Details](https://ask.dcloud.net.cn/question/158601)
* Language Server: Fixed the bug that the intermediate code is lost after the code assistant is displayed, dragged to the bottom of the editor, and press Enter at any cursor position
* Language Server: When entering a code block quickly, in some cases, the information on the right side of the code prompt window displays the bug of the results returned by other language services.
* Language Server: Fixed a bug where when there were multiple CSS classes, quickly typing a space and then pressing the left button, causing the code prompt to replace the wrong position after carriage return.
* Language Server: Fixed the bug that when there is a Chinese `,` at the end of the JSON file, the grammar check and the wavy line are not displayed when the error is reported.
* Language Server: Fixed the bug that uni-app App.vue style introduced multiple files, and the class transfer definition only took effect on the last file. [Details](https://ask.dcloud.net.cn/question/154824)
* Added uni-app run to H5, debug, support to choose to use Chrome Debug, use the built-in browser to debug (click the bug icon in the console to pop up a selection menu)
* Added uni-app manifest.json, App module configuration, added "Secure Network". [Details](https://uniapp.dcloud.net.cn/uniCloud/secure-network.html)
* uniCloud: Fixed Web Page Hosting, In some cases, the release fails and still performs the upload operation Bug.
* uniCloud: Fixed db_init.json to initialize the cloud database. When there are too many database tables, the bug of initializing the cloud database timeout.
* uniCloud: Added App packaging, console download link, one-click upload uniCloud, support to upload ipa or apk files to Aliyun official cloud storage.
* uni_modules: Added Supports configuration of module initialization scripts [Details](https://uniapp.dcloud.net.cn/plugin/uni_modules.html#package-json)
* uni_modules: Fixed the bug that the plug-in market imports the plug-in, runs slowly and times out, prompting `The plug-in processing external application request failed to complete` Bug
* uni_modules: Fixed plugin publish failed without category
* Mobile App Playground: Added support for UDID display and replication in the iOS device selection window
* Mobile App Playground: Added uts plug-in for running iOS standard base to iOS device
* Mobile App Playground: Optimize the size of iOS standard base package, only support arm64 architecture. That is, devices prior to iPhone 5S and iPad Air (mini2) are not supported. This tweak does not affect packing and custom docks.
* Mobile App Playground: Optimize the device selection window, standard base and custom base, display base information
* Mobile App Playground: Optimize the menu [Run - Mobile App Playground], remove the menu [Select Playground]
* Mobile App Playground: Fixed the bug that the device selection window refreshes the device list and the radio at the bottom is changed
* Mobile App Playground: Fixed the bug that the Node process does not end in some cases when compiling and running the uts plugin
* Mobile App Playground: iOS standard base, supports signing with Apple certificate, after signing, it can run standard base to iOS real device [Details](https://uniapp.dcloud.net.cn/tutorial/run/ios-apple-certificate-signature.html)
* Mobile App Playground: Fixed the bug that the content is not formatted after the log of Object type is opened in the console。
* Mobile App Playground: Fixed a Bug in the device selection window where HBuilderX was unable to perform any operations due to the error pop-up behind the device selection window in some cases
* Mobile App Playground: Fixed a Bug where the iOS offline SDK failed to synchronize files when the target was not HBuilder
* Mobile App Playground: Fixed the device selection window, in some cases, click the run button, the bug that HBuilderX crashes
* Mobile App Playground: Fixed the bug that the uni-app uts, Android plug-in needs to be manually downloaded and added to the lib directory when calling the API in the built-in dependency library. [Details](https://uniapp.dcloud.net.cn/plugin/uts-plugin.html#tempnotice)
* uts plug-in: Added iOS platform to support local compilation and real machine operation, need to configure Xcode environment. [Details](https://uniapp.dcloud.net.cn/tutorial/run/uts-development-ios.html)
* uts plug-in: Added Android platform, real machine operation supports three-party Gradle repository. [Details](https://uniapp.dcloud.net.cn/tutorial/run/uts-development-android.html)
* uts plug-in: Support code hints for iOS system API and Android system API.
* uts plug-in: Android platform Improve code hints for R resources.
* uts plug-in: Android platform supports import-free use of classes under java.lang.*
* uts plug-in: HBuilderX supports new uts files and platform directories.
* [uni-app plugin]
  + [Important] Added uts iOS plugin [Details](https://uniapp.dcloud.net.cn/plugin/uts-plugin.html)
  + [Important] Added `uni ext api`. Dipped the unusual API to the uni_modules plugin, but still use the uni. [Details](https://uniapp.dcloud.net.cn/api/extapi.html)
  + [Important] App-Android Fix the bug that the deviceId property of getSystemInfo occasionally fails to obtain and multiple devices are repeatedly obtained (note the backward compatibility problem caused by this modification) [Details](https://uniapp.dcloud.net.cn/api/system/info.html)
  + Vue3 project vite dependencies upgrade to the latest 3.1.8
  + Added Vue2 project Support for the use of composite APIs [Details](https://uniapp.dcloud.net.cn/tutorial/vue-composition-api.html)
  + App, Web Added Support uni.getBatteryInfo [Details](https://uniapp.dcloud.net.cn/api/system/batteryInfo.html)
  + App, Web Added Location updates event [Details](https://uniapp.dcloud.net.cn/api/location/location-change.html)
  + App, Web Add Support DarkMode [Details](https://uniapp.dcloud.net.cn/tutorial/darkmode.html)
  + App, Web Fixed Picker component date type cannot be used by the default year range [Details](https://ask.dcloud.net.cn/question/131332)
  + App, Web Fixed that the decimal point cannot be input on the numeric keyboard in iOS 16 [Details](https://ask.dcloud.net.cn/question/154584)
  + App, Web Fixed Editor component insertImage triggers input event does not have alt attributes [Details](https://ask.dcloud.net.cn/question/155163)
  + App, Web Fixed Vue3 project Editor component reloaded can not get EditorContext [Details](https://ask.dcloud.net.cn/question/154702)
  + App, Web Fixed Radio component disabled state style exception
  + App Added nvue page picker-view component adds mask-top-style, mask-bottom-style attributes [Details](https://uniapp.dcloud.net.cn/component/picker-view.html)
  + App Added nvue page MapContext supports setLocMarkerIcon method  [Details](https://uniapp.dcloud.net.cn/api/location/map.html#setLocMarkerIcon)
  + App Updated Video component supports the title attribute [Details](https://uniapp.dcloud.net.cn/component/video.html)
  + App Updated Vue3 project Set minUserAgentVersion to 49 [Details](https://uniapp.dcloud.net.cn/collocation/manifest.html#appwebview)
  + App Updated Vue2 project component.is support ComponentDefinition / ComponentConstructor [Details](https://ask.dcloud.net.cn/question/140044)
  + App Updated uts plugin supports compile cache
  + App Fixed hover-class attribute does not support multiple class [Details](https://ask.dcloud.net.cn/question/152506)
  + App Fixed Vue3 project ust plug-in export default class does not take effect [Details](https://ask.dcloud.net.cn/question/154164)
  + App Fixed Vue3 project v-for may rendering failure [Details](https://ask.dcloud.net.cn/question/154836)
  + App Fixed Vue3 project tabbar.broderStyle custom color value invalid [Details](https://ask.dcloud.net.cn/question/150718)
  + App Fixed Vue3 project nvue page switch component disabled attribute is invalid [Details](https://ask.dcloud.net.cn/question/154577)
  + App Fixed Vue2 project Event exception caused by remove page root node [Details](https://ask.dcloud.net.cn/question/155057)
  + App Fixed Vue2 project Updating data when the list does not use index as the key results in an event exception [Details](https://ask.dcloud.net.cn/question/155238)
  + App Fixed When Vue2 project uses composite API, onReady declaration cycle template ref is not bound
  + App Fixed Vue3 project template ref will be proxied
  + App Fixed Vue3 project setting the background color of the navigation bar to rgba is invalid [Details](https://ask.dcloud.net.cn/question/135111)
  + App Fixed Vue3 project root node height: 100% is invalid [Details](https://ask.dcloud.net.cn/question/156564)
  + App Fixed Vue2 project editing uts plugin code hot update invalid
  + App Fixed Vue2 project nvue page does not support the uts plugin [Details](https://ask.dcloud.net.cn/question/157435)
  + App Fixed Setting the statusBar color in darkmode is not normal
  + App Fixed nvue homepage setting navigationBarTextStyle is invalid [Details](https://ask.dcloud.net.cn/question/150485)
  + App Fixed The position calculation of nvue page slider component is inaccurate in some cases [Details](https://ask.dcloud.net.cn/question/152714)
  + App-Android Fixed in version 3.5.5 that caused the input component to automatically get the focus may fail [Details](https://ask.dcloud.net.cn/question/153481)
  + App-Android Fixed uni.getStorageSync may report a 'SyntaxError' error in some cases [Details](https://ask.dcloud.net.cn/question/154284)
  + App-Android Fixed uni.request does not support head requests [Details](https://ask.dcloud.net.cn/question/136717)
  + App-Android Fixed Getting focus cursor position may be incorrect when there are multiple input components in the page
  + App-Android Fiexed The nvue live-pusher component cannot be previewed on Android11+ devices using mobile networks [Details](https://ask.dcloud.net.cn/question/156532)
  + App-iOS Fixed nvue swiper component uses rpx may not slide properly to switch on some devices [Details](https://ask.dcloud.net.cn/question/149260)
  + App-iOS Fixed The nvue page occasionally crashes when turning off or on the pull-down refresh on iOS16 devices
  + App-iOS Fixed Vue3 project recording playback is invalid [Details](https://ask.dcloud.net.cn/question/155741)
  + App Fixed that there is no text prompt for loading when uni.startSoterAuthentication (biometric identification) is wrong [Details](https://ask.dcloud.net.cn/question/157353)
  + App-iOS Fixed UniPush 2.0. After enabling offline push in the vue2 project, call uni.getPushClientId In some cases, the bug that cannot get the cid [Details](https://ask.dcloud.net.cn/question/158921)
  + Web Updated uni.preViewImage adds switching and closing buttons on the PC
  + Web Fixed Tabbar shows the duplicate Badge in some cases [Details](https://ask.dcloud.net.cn/question/153336)
  + Web Fixed uni.openLocation navigation does not automatically obtain the current position [Details](https://ask.dcloud.net.cn/question/155066)
  + Web Fixed Vue3 project titlenView's selection is not displayed when select is true [Details](https://ask.dcloud.net.cn/question/153179)
  + Web Fixed Vue3 project enters tabbar repeatedly trigger onLoad event [Details](https://ask.dcloud.net.cn/question/154066)
  + Web Fixed v-bind in the Vue3 project CSS does not take effect with rpx [Details](https://github.com/dcloudio/uni-app/issues/3884)
  + Web Fixed Vue2 project Using the page selector in CSS media queries does not take effect
  + Web Fixed Vue3 project --window-top calculation error [Details](https://ask.dcloud.net.cn/question/157164)
  + Web Fixed Vue3 project configuration global loading and error components are invalid [Details](https://ask.dcloud.net.cn/question/157122)
  + Web Fixed The Vue3 project canvas component listens to the event and reports an error [Details](https://ask.dcloud.net.cn/question/158252)
  + Mini Program Fixed When changing the data, setdata calls abnormalities [Details](https://github.com/dcloudio/uni-app/issues/3787)
  + Mini Program Fixed v-bind in the Vue3 project CSS does not take effect in the data in non-setup [Details](https://github.com/dcloudio/uni-app/issues/3887)
  + Mini Program Fixed Vue3 project action domain slot nesting may render failed when used [Details](https://github.com/dcloudio/uni-app/issues/3886)
  + Mini Program Fixed Vue3 project the static data rendering of the scoped slot is failed [Details](https://ask.dcloud.net.cn/question/153150)
  + Mini Program Fixed Vue3 project static data rendering errors in the role of the field slot [Details](https://ask.dcloud.net.cn/question/155008)
  + Mini Program Fixed The Vue3 project is issued to a mixed subcontract, and the page return may be reported to an error [Details](https://github.com/dcloudio/uni-app/issues/3923)
  + Mini Program Updated The vue3 project uses import to import resources in non-static directories. After generation, the name is added to the hash by default. [Details](https://github.com/dcloudio/uni-app/issues/4011)
  + Weixin Mini Program Added uni-AD rewarded video add secured callback [Details](https://uniapp.dcloud.net.cn/component/ad-weixin.html)
  + Weixin Mini Program Fixed drag-related events of the Vue3 project in scroll-view do not trigger [Details](https://github.com/dcloudio/uni-app/issues/3921)
  + Weixin Mini Program Fixed uni://form-field invalid in Vue3 project [Details](https://ask.dcloud.net.cn/question/155373)
  + Weixin Mini Program Fixed Vue3 project v-for loop events may be messed up [Details](https://github.com/dcloudio/uni-app/issues/4015)
  + Weixin Mini Program Fixed Vue3 project wxs hot update fails [Details](https://ask.dcloud.net.cn/question/158252)
  + Baidu Mini Program Fixed uni.createIntersectionObServer cannot listen to multiple nodes [Details](https://github.com/dcloudio/uni-app/issues/3835)
  + Baidu Mini Program Fixed Static resources in node_modules directory build error [Details](https://ask.dcloud.net.cn/question/154595)
  + Baidu Mini Program Fixed OnInit lifetimes is not triggered [Details](https://ask.dcloud.net.cn/question/154352)
  + Baidu Mini Program Fixed The Vue2 project uses usingSwanComponents to configure the event in the dynamic library component that cannot get parameters [Details](https://ask.dcloud.net.cn/question/155281)
  + Baidu Mini Program Fixed Vue3 project cannot use dynamic library components normally [Details](https://github.com/dcloudio/uni-app/issues/3864)
  + Alipay Mini Program Added Supports monitoring keyboard height changes using uni.onKeyboardHeightChange [Details](https://uniapp.dcloud.net.cn/api/key.html#onkeyboardheightchange)
  + Alipay Mini Program Fixed After compiled into a mini program plug-in, uni.hideloading and other interfaces cannot be accessed [Details](https://github.com/dcloudio/uni-app/issues/2974)
  + Alipay Mini Program Fixed page-container component is compiled as a custom component [Details](https://ask.dcloud.net.cn/question/154028)
  + Alipay Mini Program Fixed invalid duration attribute in uni.showToast [Details](https://ask.dcloud.net.cn/question/147279)
  + Alipay Mini Program Fixed The component without events in the plug-in report an error [Details](https://github.com/dcloudio/uni-app/pull/3903)
  + Alipay Mini Program Fixed Events in the Mini Program component are triggered earlier and cannot be listened to in the Vue component
  + Alipay Mini Program Fixed uni.showLoading prompts that the mask parameter is invalid [Details](https://ask.dcloud.net.cn/question/156944)
  + Alipay Mini Program Fixed Vue3 project eventChannel communication failed [Details](https://github.com/dcloudio/uni-app/issues/3945)
  + Alipay Mini Program Fixed page-meta component root-font-size property invalid [Details](https://ask.dcloud.net.cn/question/157168)
  + QQ Mini Program Fixed Vue3 uni.createCanvasContext passing this returns an error [Details](https://ask.dcloud.net.cn/question/154223)
  + ByteDance Mini Program Added Support the use of mini program plugins [Details](https://github.com/dcloudio/uni-app/issues/3917)
  + ByteDance Mini Program Fixed Vue3 project uses mini program custom components that may report an error [Details](https://github.com/dcloudio/uni-app/issues/3915)
  + ByteDance Mini Program Updated component2 is enabled by default [Details](https://ask.dcloud.net.cn/question/156550)
  + Kuaishou Mini Program Added Pages support subPackages [Details](https://uniapp.dcloud.net.cn/collocation/pages.html#subpackages)
  + Kuaishou Mini Program Update uni.requestPayment payment interface is compatible with calling ks.pay [Details](https://ask.dcloud.net.cn/question/152948)
  + uni-statistics Fixed The bug of inaccurate deviceId acquisition method caused by version 3.4.9, resulting in inaccurate statistics of unistatistics 2.0 App-Android platform [details](https://ask.dcloud.net.cn/article/40097)
  + uni-im supports projects that are not uniCloud or based on uni-id-pages [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-im.html)
  + uni-im Full support for Vue3 [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-im.html)
  + hello uts Added System API Alert popup example [Details](https://ext.dcloud.net.cn/plugin?id=9892)
  + hello uts Updated iOS platform three-party SDK toast message prompt box, example of monitoring device location changes [Details](https://ext.dcloud.net.cn/plugin?id=9892)
* [uniCloud plugin]
  + [Important] Added uni-im cloud integrated, full platform, free, open source instant messaging system [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-im.html)
  + [Important] Added Secure network, For secure communication between clients and cloud functions and cloud objects [Details](https://uniapp.dcloud.net.cn/uniCloud/secure-network.html)
  + uniCloud client sdk Added uniCloud.databaseForJQL api to get database reference [Details](https://uniapp.dcloud.net.cn/uniCloud/clientdb.html#jssdk)
  + uniCloud client sdk Added uniCloud.importObject add options.parseSystemError to parse uncaught exception for auto ui [Details](https://uniapp.dcloud.net.cn/uniCloud/cloud-obj.html#auto-ui)
  + Cloud Object Added Call cloud object with url support mulit segment path [Details](https://uniapp.dcloud.net.cn/uniCloud/http.html#request-co-url)
  + HBuilderX Plugin Added [OpenDB Check for Updates] to the right-click menu of schema file which starts with 'uni-'
  + HBuilderX Plugin Fixed The called function return noting causes error when call function by function
  + HBuilderX Plugin Fixed Local cloudfuntion calls the redis interface report an error when transferring large data [Details](https://ask.dcloud.net.cn/question/155804)
  + HBuilderX Plugin Fixed Require error is only reported once when connect to local cloud function
  + HBuilderX Plugin Fixed Aliyun business version cloud storage file is not visible in uniCloud web which was upload by local cloud function [Details](https://ask.dcloud.net.cn/question/159109)
  + JQL Added Trigger is supported, which can be used to excute some logic before or after database operation. Using jql syntax in trigger is supported. [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#trigger)
  + JQL Added Using jql syntax in schema.ext is supported [Details](https://uniapp.dcloud.net.cn/uniCloud/jql-schema-ext.html#using-jql-syntax)
  + JQL Added "geoNear" stage is supported [Details](https://uniapp.dcloud.net.cn/uniCloud/jql.html#geo-near)
  + JQL Fixed Using negative value as literal in where or permission cause error [Details](https://ask.dcloud.net.cn/question/157993)
  + JQL Fixed Some legal jql requests falsely report permission errors
  + JQL Fixed Using add aggregate operator report an error [Details](https://ask.dcloud.net.cn/question/156261)
  + JQL Fixed Using some reserved js keywords in where or field report an error
  + JQL Fixed When querying a joined table with getTemp, an error bug is reported if the associated field of the main table is of array type in the schema but the actual data does not have this field
  + uniIdRouter Fixed Router api error in vue3 project [Details](https://ask.dcloud.net.cn/question/158015)
  + uniIdRouter Fixed "uniIdRedirectUrl" parameter is incorrect when using relative paths [Details](https://ask.dcloud.net.cn/question/155904)
  + uni-id-co Added password setting API [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#set-pwd)
  + uni-id-co Added external system joint login API, which can create an account corresponding to uni-id for the external system, so that the account can use the system and functions that depend on uniId [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#external)
  + uni-id-co Added authentication signature verification when HTTP requests [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#http-reqeust-auth)
  + uni-id-co Added error code `uni-id-account-not-exists-in-current-app` when the matched user cannot login in the current app  [Error Code Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#errcode)
  + uni-id-co Added Support custom password hash/encrypt method [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#custom-password-encrypt)
  + uni-id-co Added Invoke uni-id-co using HTTP request [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#adapter-http)
  + uni-id-co Added support for WeChat authorized mobile phone number login method [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#login-by-weixin-mobile)
  + uni-id-co Added Unbind third-party platform account [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#unbind-third-account)
  + uni-id-co Added WeChat binding mobile phone number to support `code` binding via `getPhoneNumber` event callback [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#bind-mobile-by-mp-weixin)
  + uni-id-co Fixed error that the user did not set the avatar when logging in on WeChat
  + uni-id-co Fixed Unable to get uniIdToken from clientInfo
  + uni-id-co Upgrade Using hmac-sha256 as password hash method [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#password-safe)
  + uni-id-pages Added Jump to set password page configuration item `setPasswordAfterLogin` after login [详情](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#set-pwd-after-login)
  + uni-id-pages Added setting password page
  + uni-id-pages Upgrade toast error prompt time to 3 seconds
  + uni-admin Added bulk SMS function [Details](https://uniapp.dcloud.net.cn//uniCloud/admin.html#batch-sms)
  + uni-admin Fixed a bug where some statistics of the uni-statistics App-Android platform were inaccurate
  + uni-admin Fixed uni-statistics2 Bug where the week/month data is inaccurate
  + uni-admin Upgrade schema file naming convention of the bulk SMS function, change `batch-sms-template` `batch-sms-task` `batch-sms-result` to `opendb-sms-temlate` `opendb-sms-task` `opendb-sms-log` conforms to the opendb specification.
  + uni-clear-temp-data Added expired data and temporary file cleaning plugin [Details](https://ext.dcloud.net.cn/plugin?id=9826)
* [App plugin (5+ App & uni-app)]
  + Added Stripe supports setting up billing information [Details](https://uniapp.dcloud.net.cn/tutorial/app-payment-stripe.html)
  + Added Record, Camera, Barcode, Orientation modules [Details](https://uniapp.dcloud.net.cn/tutorial/app-modules.html#bcor)
  + Android Update the Paypal SDK to version 0.6.2, fixed the issue that setting targetSdkVersion to 31 packaging failed [Details](https://ask.dcloud.net.cn/question/154976)
  + Android Fixed plus.device.uuid may be getting same unique identity on different devices
  + Android Fixed App settings only support portrait when on some Android 8 devices may cause crash
  + Android Fixed LivePusher may cause the app to crash in some scenarios [Details](https://ask.dcloud.net.cn/question/147593)
  + Android Fixed The mute state of VideoPlayer may not work after switching video resources [Details](https://ask.dcloud.net.cn/question/153257)
  + Android Fixed VideoPlayer may cause stuttering when destroyed [Details](https://ask.dcloud.net.cn/question/153483)
  + Android Fixed VideoPlayer does not display the title bar in some cases
  + Android Fixed chooseVideo Using the camera to capture video may fail on Android 10 and above devices [Details](https://ask.dcloud.net.cn/question/155877)
  + Android Fixed Listen for the system dark mode theme switching event may be invalid [Details](https://ask.dcloud.net.cn/question/157497)
  + Android Fixed Cloud package using your owned certificates may report an 'Invalid keystore format' error [Details](https://ask.dcloud.net.cn/question/157057)
  + Android Fixed Cloud package fails when the package property value of AndroidManifest.xml is the same as the package name
  + iOS Fixed VideoPlayer's title bar and progress bar style are incorrect [Details](https://ask.dcloud.net.cn/question/153945)
  + iOS Fixed When sharing to WeChat favorites, jump to the moments [Details](https://ask.dcloud.net.cn/question/155362)
  + iOS Fixed TitleNView setting the default navigation bar color can cause inconsistencies with the status bar color
  + iOS Fixed setUIStyle setting dark mode may not work
  + iOS Fixed plus.screen.lockOrientation/plus.screen.unlockOrientation invalid on iOS16 devices [Details](https://ask.dcloud.net.cn/question/155357)
  + iOS Fixed Recording does not work when playing audio [Details](https://ask.dcloud.net.cn/question/157408)
  + iOS Fixed Setting DarkMode to follow the system theme may not work

## 3.6.5.20221121
* Fixed windows built-in browser, drag the built-in browser, HBuilderX crashes the bug
* Fixed the bug that uni-app runs to the built-in browser, and in some cases, the cookies are inconsistent
* [uni-app plugin]
  + Fixed TypeScript in the Vue2 project uses an error in lifecycle such as onLoad [Details](https://ask.dcloud.net.cn/question/157035)
  + App-Android Fixed uni.getStorageSync may report a 'SyntaxError' error in some cases [Details](https://ask.dcloud.net.cn/question/154284)
  + Baidu Mini Program Fixed OnInit lifetimes is not triggered [Details](https://ask.dcloud.net.cn/question/154352)
  + Alipay Mini Program Fixed invalid duration attribute in uni.showToast [Details](https://ask.dcloud.net.cn/question/147279)
  + Alipay Mini Program Fixed uni.showLoading prompts that the mask parameter is invalid [Details](https://ask.dcloud.net.cn/question/156944)
* [uniCloud plugin]
  + [Important] Aliyun business version is avaliable [Details](https://ask.dcloud.net.cn/article/40144)

## 3.6.4.20220922
* Language Server: Fixed the bug that the CSS code prompt speed is too slow for large CSS files
* Language Server: Fixed the bug of false positives in syntax verification in some cases when tsconfig.json exists in the uni-app project
* Language Server: Fixed the bug that in some cases, the language service frequently reported errors and crashed, and the bug of frequent pop-up errors in the lower right corner of the HBuilderX window
* Mobile App Playground: Fixed the bug that the custom dock made by Android Studio, when running to Android devices, reported an error
* Mobile App Playground: Fixed the bug that uni-app runs to the iOS simulator, modifies the nvue file, and cannot synchronize the modification
* Mobile App Playground: Fixed the bug that when uni-app is run to the mobile phone, in some cases, the console displays `compiled successfully` and there is no response
* Mobile App Playground: Fixed the bug that uni-app runs to the Android 4.4 emulator and prompts that the base cannot be found
* [uni-app plugin]
  + Fixed HBuilderX version 3.6.2 introduces a bug uni.onPushMessage The API cannot listen to the click events of push messages and notification bar messages [Details](https://ask.dcloud.net.cn/question/153964)
  + App-Android Fixed The input component automatically gets the focus may fail caused by version 3.6.2 [Details](https://ask.dcloud.net.cn/question/153481)
* [uniCloud plugin]
  + Fixed HBuilderX version 3.6.2 introduces a bug in which a client calls a cloud function within a cloud function when connecting to a local Tencent cloud function and reports an error
* [App plugin (5+ App & uni-app)]
  + Android Fixed App does not work properly on Android 4.4 devices caused by version 3.6.2 [Details](https://ask.dcloud.net.cn/question/153910)
  + iOS Fixed Uni native language plugin Hook does not have applicationWillEnterForeground/applicationDidEnterBackground event caused by version 3.6.2

## 3.6.3.20220917
* Fixed the bug that the editor closes the tab, and crashes in some cases
* Fixed the bug of Windows built-in browser, mobile device mode, unable to select elements
* Fixed the bug that when switching to other programs during the HBuilderX code prompt process, the code prompt window would cover other programs in some cases
* Language Server: Fixed the bug of invalid px to rpx in uni-app cli project
* Fixed console log, some types of log output bugs
* Fixed the bug that uni-app runs to the iOS simulator, the console log is truncated or the output is incomplete
* [uni-app plugin]
  + Mini Program Fixed onReady lifecycle fires twice [Details](https://ask.dcloud.net.cn/question/153422)
  + App Fix the bug that the pushClientId could not be obtained after UniPush 2.0 enabled offline push in the vue2 project [Details](https://ask.dcloud.net.cn/question/153322)
* [uniCloud plugin]
  + [Important] Added The uni-starter version 2.0 is released, which integrates the common functions of commercial projects and the rapid development project template of cloud integrated applications [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-starter.html)
  + [Important] Added The uni-admin 2.0 version is released, which is an open source framework for application background management based on uni app and uniCloud [Details](https://uniapp.dcloud.net.cn/uniCloud/admin.html)
  + uni-id-pages Added Administrator registration page, and provide the configuration item 'isAdmin' to distinguish whether it is the management end [Details](https://ext.dcloud.net.cn/plugin?id=8577)
  + uni-id-pages Added Three automatic jump behaviors after successful login; The priorities are as follows: route carry (uniIdRedirectUrl parameter) > return to the previous route > jump home [Details](https://ext.dcloud.net.cn/plugin?id=8577)

## 3.6.2.20220914
* Added UTS syntax support. Develop native using TypeScript [Details](https://en.uniapp.dcloud.io/tutorial/syntax-uts.html)
* Added the function of finding references, currently only supports js and ts
* Windows: Upgrade built-in browser, Upgrade Cef version to 90.6.7
* HBuilderX settings, plugin configuration, add configuration items, Enable JavaScript Validation, Enable TypeScript Validation
* Language Server: Added real-time verification of variable syntax in vue and js (js verification needs to be enabled in [Settings - Plugin Configuration])
* Language Server: Added built-in syntax check to support warning level
* Language Server: Added vue3 `style module` to support code hints
* Language Server: Added vue2&3 `slot` to support code hints
* Language Server: Added vue2&3 script area to support automatic package import
* Language Server: Fixed the bug that vuedoc does not take effect in script setup
* Language Server: Fixed The custom component of vue3 `script setup` import, the bug that cannot be prompted in the template area
* Language Server: Fixed the bug that `()` will be repeatedly generated when modifying the name of the function call
* Language Server: Fixed the bug that special String does not support `if(idstr === '|')`
* Language Server: Fixed the bug that the variable suspension in the vue template area does not take effect
* Language Server: Fixed `uniCloud.importObject()`, after the cloud object is modified, the code prompt and suspension cannot take effect in real time
* Language Server: Optimized `uniCloud.importObject()`, code hints for parameters and return values ​​when calling methods on cloud objects
* Language Server: Fixed the bug that the framework package of the vetur specification could not take effect in real time when it was installed and uninstalled
* Language Server: Fixed the bug that the suspension of variables and functions referencing other files in the html script did not take effect
* Language Server: Fixed the bug that the return value and parameter type are incorrect when parsing the function that references other files in the html script
* Language Server: Fixed the bug that the frame syntax library of the status bar at the bottom of HBuilderX did not take effect when removed
* Language Server: Fixed the vue-cli project, the script area in vue will not recognize the bug of tsconfig.json under the project
* Language Server: Optimization After setting `px` to `rem`, the conversion prompt is placed in the first item of the code prompt
* Language Server: Fixed JavaScript `Object.` does not prompt the bug of es6+ new methods
* Language Server: Fixed `import xxx from 'XXX.vue'` without the vue suffix, prompting that the module cannot be found, and cannot go to the defined bug
* Language Server: Fixed the bug that the code prompt could not be automatically triggered when typing the character `.` in jsx and tsx files
* Fixed Editor, Close Tab, in some cases, the bug of not remembering the folded state
* Added tabs Right-click menu Add menus Move tabs to the left, move tabs to the right
* Windows: Fixed the bug that when HBuilderX is not started, when importing the plugin market plugin, the UI view of the first import shows a blank bug
* Fixed the bug that the jump position is wrong in some cases of multi-file character search
* Fixed the bug that when going back to another file, the cursor jumps to the beginning of the file instead of going to the position before the definition
* Added new project, HBuilderX plugin, added internationalization example template
* Fixed the bug that debug view, variable, Global node, UI display disorder
* Fixed the bug that HBuilderX saves files in utf-8 format without file header identification byte 0xEFBBBF
* Mobile App - Cloud packaging: Fixed the bug that when the static resource file under the project is too large (over 100M), the packaged bug cannot be submitted
* Mobile App - Cloud packaging: Fixed the bug that HBuilderX crashed when submitting packaging in some cases on Windows
* Mobile App Playground, using Node to run, no longer relying on Java
* Added Mobile App Playground, Device selection window, added base selection function
* Fixed Mobile App Playground, When the project path exists in Chinese and runs to an iOS device, the App page displays an abnormal bug
* Fixed Mobile App Playground, a bug where custom base installation failed in some cases
* uni-app: Build, H5 and Mini-Programe, window UI text internationalization
* uni-app：Fixed manifest.json, a bug that the uniPush field becomes null in some cases
* uni-app: Fixed manifest.json After the application name is internationalized, the packaging interface, the application name displays `%%`
* uni-app: Adjust the H5 configuration on the left side of manifest.json to the Web configuration
* [uni-app plugin]
  + [Important] Added uts Android plugin [Details](https://uniapp.dcloud.net.cn/plugin/uts-plugin.html)
  + Fixed Compile exception when project path contains parentheses. [Details](https://ask.dcloud.net.cn/question/150173)
  + App Updated The web-view for Vue2 project can use webviewStyles set more style. [Details](https://ask.dcloud.net.cn/question/149212)
  + App Updated The web-view for Vue page can drawn outside of safe area by default. [Details](https://ask.dcloud.net.cn/question/149472)
  + App Fixed Vue page cover-view component flex layout is invalid. [Details](https://ask.dcloud.net.cn/question/151697)
  + App Fixed Vue3 project uni.getSystemInfo gets windowHeight value is inaccurate. [Details](https://ask.dcloud.net.cn/question/150862)
  + App Fixed Vue3 project vue page map component shows error after updating center coordinates. [Details](https://ask.dcloud.net.cn/question/151438)
  + App-Android Fixed the bug that the overlapping coordinates of the nvue map marker points cannot be displayed [Details](https://ask.dcloud.net.cn/question/149665)
  + App-Android Fixed the bug that the nvue map component does not take effect when the polyline and polygon data are cleared
  + App-Android Fixed uni.saveImageToPhotosAlbum saving network pictures may overwrite the last saved picture. [Details](https://ask.dcloud.net.cn/question/125357)
  + App-Android Fixed Picker component focus acquisition exception. [Details](https://ask.dcloud.net.cn/question/150454)
  + App-Android Fixed Nvue page map component customCallout setting image may cause application crash. [Details](https://ask.dcloud.net.cn/question/150166)
  + App-Android Fixed bindingx may cause exceptions when executing evaluatecolor [Details](https://ask.dcloud.net.cn/question/151759) 
  + App-Android Fixed uni.reLaunch opens non-tabbar nvue pages may still show tabbar [Details](https://ask.dcloud.net.cn/question/143792)
  + App-Android Fixed AutoNavi Maps not working properly when setting GooglePlay channel [Details](https://ask.dcloud.net.cn/question/152668)
  + App-Android Fixed using the picker in nvue as homepage may cause the app to become unresponsive [Details](https://ask.dcloud.net.cn/question/151819)
  + App-iOS Fixed the bug that uni.setTabBarItem dynamic update icon may not take effect [Details](https://ask.dcloud.net.cn/question/149955)
  + App-iOS Fixed the bug that the nvue map component may not be loaded properly in multiple pages when use Google map moudle [Details](https://ask.dcloud.net.cn/question/150080)
  + App-iOS Fixed The values of bluetoothEnabled and locationEnabled obtained by uni.getSystemSetting are inaccurate.
  + App-iOS Fixed The nvue page map component marker calls the moveAlong method without interrupting the previous animation. [Details](https://ask.dcloud.net.cn/question/151411)
  + App-iOS Fixed The nvue page ad-content-page component may cause the app to crash in some scenarios. [Details](https://ask.dcloud.net.cn/question/151778)
  + App-iOS Fixed uni.openLocation bottom safe area adaptation problem [Details](https://ask.dcloud.net.cn/question/150074)
  + App-iOS Fixed That uni.chooseLocation may cause the app to crash [Details](https://ask.dcloud.net.cn/question/152367)
  + App-iOS Fixed Nvue Tabbar page uni.reLaunch could not triggered onUnload lifetimes [Details](https://ask.dcloud.net.cn/question/152738)
  + Web Added Support for configuring and using AutoNavi maps [Details](https://uniapp.dcloud.io/collocation/manifest?id=h5sdkconfigmaps)
  + Web Updated The web-view component support props of fullscreen. [Details](https://uniapp.dcloud.net.cn/component/web-view.html)
  + Web Fixed The touch envet stop and prevent for canvas component are invalid. [Details](https://ask.dcloud.net.cn/question/148195)
  + Web Fixed Vue3 project css environment variable --window-top calculation error. [Details](https://ask.dcloud.net.cn/question/150842)
  + Web Fixed Vue3 project release mode showLoading icon size display error. [Details](https://ask.dcloud.net.cn/question/149819)
  + Web Fixed custom-tab-bar component using uni.setTabBarItem to set visible is invalid. [Details](https://ask.dcloud.net.cn/question/132947)
  + Web Fixed Calling uni.setClipboardData will bring up the keyboard [Details](https://github.com/dcloudio/uni-app/issues/3569)
  + Mini Program Fixed v-model fails after complex expressions are used in v-for. [Details](https://github.com/dcloudio/uni-app/issues/3173)
  + Mini Program Fixed Updated The Mini Program component supports the use of kebab-case event names [Details](https://github.com/dcloudio/uni-app/issues/1802)
  + Alipay Mini Program, Baidu Mini Program, Kuaishou Mini Program, ByteDance Mini Program Updated Support automatic copying of ext.json files.  
  + Weixin Mini Program Fixed Calling triggerEvent in wxs cannot carry event parameters [Details](https://github.com/dcloudio/uni-app/issues/3829)
  + Alipay Mini Program Updated The uni.saveImageToPhotosAlbum interface no longer uses the legacy saveImage interface.
  + Alipay Mini Program Fixed Compiling error after configuring global Mini Program components [Details](https://github.com/dcloudio/uni-app/issues/3619)
  + Alipay Mini Program Fixed Accessing $slots after enabling Mini Program Basic Library 2.0 configuration [Details](https://github.com/dcloudio/uni-app/issues/3529)
  + ByteDance Mini Program Added vue2 project to support onUploadDouyinVideo lifetimes [Details](https://ask.dcloud.net.cn/question/151113)
  + ByteDance Mini Program Fixed Component fails to render when repeatedly creating and destroying pages quickly.
* [uniCloud plugin]
  + Updated UniCloud HBuilderX plugin, Change parameter of running cloud object by HBuilderX [Details](https://uniapp.dcloud.net.cn/uniCloud/rundebug.html#run-obj-param)
  + Updated Aliyun Extend the timeout of database request from 3s to 5s
  + Added Aliyun Implement eip with http proxy provided by aliyun [Details](https://uniapp.dcloud.net.cn/uniCloud/cf-functions.html#http-proxy-client)
  + Added CloudFunction Add context.requestId to get current request id in cloudfunction [Details](https://uniapp.dcloud.net.cn/uniCloud/cf-functions.html#context)
  + Added CloudObject Add this.getUniCloudRequestId() to get current request id in cloudobject [Details](https://uniapp.dcloud.net.cn/uniCloud/cloud-obj.html#get-request-id)
  + Added CloudSdk Add uniCloud.getRequestList to get the list of request id being processed by current cloudfunction instance [Details](https://uniapp.dcloud.net.cn/uniCloud/cf-functions.html#get-request-list)
  + Added CloudSdk Add uniCloud.getCloudInfos to get the list of cloud info being processed by current cloudfunction instance [Details](https://uniapp.dcloud.net.cn/uniCloud/cf-functions.html#get-cloud-infos)
  + Added CloudSdk Add uniCloud.getClientInfos to get the list of client info being processed by current cloudfunction instance [Details](https://uniapp.dcloud.net.cn/uniCloud/cf-functions.html#get-cloud-infos)
  + Fixed ClientSdk Using uniCloud object cause error when uniCloud space was not bound to project [Details](https://github.com/dcloudio/uni-app/issues/3758)
  + Fixed JQL Multi parentKey in schema is unable to query with getTree [Details](https://ask.dcloud.net.cn/question/151834)
  + Fixed UniCloudDebugger Extension is not loaded properly in some situation [Details](https://ask.dcloud.net.cn/question/150357)
  + Fixed UniCloudDebugger Memory leak of dev server which cause slow responding
  + Updated uniIdRouter It's able to intercept home page or launch page loading now
  + Updated uni-id-co Password rule updated, password strength is configurable. [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#password-strength)
  + Updated uni-id-co Save user openid into `wx_openid.${mp|h5|app|web}` and `wx_openid.${mp|h5|app|web}_${DCloudAppId}` of user record [Login by weixin](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#login-by-weixin)、[Login by QQ](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#login-by-qq)
  + Updated uni-id-co Save user session_key, access_token with uni-open-bridge-common [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#save-user-token)
  + Added uni-id-co Add beforeRegister hook to manipulate user record before register [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-summary.html#before-register)
  + Added uni-id-pages Support login by weixin official account web page and wechat's qrcode of web page [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#weixinlogin)
  + Added uni-id-pages Support password strength (whether it must contain upper and lower case letters, numbers, special symbols and length) configuration [Details](https://uniapp.dcloud.net.cn/uniCloud/uni-id-pages.html#config)
  + Added uni-id-pages Add global login success event: `uni-id-pages-login-success`, listen this event by [uni.$on](https://uniapp.dcloud.net.cn/api/window/communication.html#on)
  + Added IP anti-brushing for cloudfunction and clientDB [Details](https://uniapp.dcloud.net.cn/uniCloud/ip-filter.html)
  + Fixed use uniCloud inside main.js cause error in some situation
  + Fixed uni-admin vue3 The value of showLeftWindow is incorrect after uni.showLeftWindow was called [Details](https://ask.dcloud.net.cn/question/149618)
  + Added uni-statistics2 Add config item to set the duration of periodic reporting of data [Details](https://uniapp.dcloud.net.cn/uni-stat-v2.html#report-time)
* [App plugin (5+ App & uni-app)]
  + Android Fixed Get the opposite width and height of a vertical video file with getVideoInfo [Details](https://ask.dcloud.net.cn/question/151205)  
  + Android Fixed Offset may appear when previewing images with previewImage [Details](https://ask.dcloud.net.cn/question/151966)
  + Android Fixed the payload field of vendor channel does not support non JSON strings in UniPush 2.0
  + Android Fixed the option parameter setting when field of creating local message with plus.push.createMessage is invalid
  + Android Fixed upgrade APK with plus.runtime.install may report null pointer
  + iOS Fixed submit to App Store Connect report warning 'ITMS-90078: Missing Push Notification Entitlement' without push module
  + iOS Fixed The uploadedSize value obtained by uploading a file using uploader is inaccurate
  + iOS Fixed the display time of slow motion video when select it from album is not accurate [Details](https://ask.dcloud.net.cn/question/150531)
  + iOS Fixed use baidu location module needs enable IDFA caused by version 3.5.0

## 3.5.3.20220729
* Added HBuilderX status bar Upgrade added red dot prompt
* Added MarkDown code block to support language coloring and highlighting, you need to download and add the corresponding language coloring extension plug-in
* Added Markdown support to go to `#title` or `@`alias of title across files
* Added TypeScript support for syntax verification
* Added language service to support tailwindcss, need to install tailwindcss plugin [Details](https://ext.dcloud.net.cn/plugin?id=8560)
* Fixed language service React, add `()` bug after `<App />` carriage return
* Fixed language service React jsx file no code hint bug
* Fixed language service CSS pointer-events missing auto attribute bug
* Fixed the bug of code block settings, custom other language code blocks, two JSON options appear in the window list
* Fixed the bug that the `$DATE_TIME` in the comment of the custom code block displays the wrong date
* Fixed the operating system environment variable, configuring `NODE_OPTIONS --openssl-legacy-provider`, HBuilderX loses response when it starts
* Fixed the bug that the plugin API `hx.window.showQuickPick()` window could not scroll after opening the terminal
* Fixed the bug that the cursor position is wrong after opening the document for the first time and editing it for the first time
* Fixed the bug that the editor selects the language association window position offset
* Fixed the bug of plugin installation try move failed in some cases
* Git plugin, pull operation, the default option is changed to the fourth item, namely `git pull --rebase --autostash`
* Fixed some issues for language service

## 3.4.18.20220630
* Fixed the bug that json file search index symbol causes crash.
* Fixed the bug that the closed tag does not have a dotted box after the html tag is selected.
* Fixed the bug that the hover list disappears automatically when Windows opens the terminal, searches for categories in the toolbar, and moves the mouse to it.

## 3.4.15.20220610
* Fixed PHP files, comment shortcuts, comment bugs

## 3.4.14.20220607
* Added HBuilderX Support for custom project Snippets
* Added support for running and debugging Node programs
* Some of the built-in language syntax highlighting was migrated to the plug-in marketplace
* Added syntax highlighting that can be independently extended for new languages, and language highlighting plug-ins can be developed or downloaded
* Added language service, JavaScript supports DOM type recognition of id selectors in Document. getElementById and Document. querySelector
* Added language service, SCSS support for prompt `!global` and `!default`
* Added language service, VUE-CLI projects, code hints support element-UI, bootstrap-vue, etc
* Fixed language service, input CSS code in the same line, press Enter, replace the wrong position Bug
* Fixed language service, jsdoc carriage return error Bug
* Fixed Emmet syntax bug where pressing TAB did not respond correctly
* Fixed multi-file search, the right side of the display code coloring error Bug
* Fixed plug-in installation window, installed plug-in, version number display error Bug

## 3.4.7.20220422
* Fixed some issues for language service

## 3.4.6.20220420
* HBuilderX language service switched from Java to Node
* Fixed a bug where files in the editor would not be automatically refreshed after Git updated files in some cases
* Adjust Share to Weblink, adjust code area code coloring

## 3.3.13.20220314
* Fixed some minor issues

## 3.3.11.20220210
* Fixed some minor issues

## 3.3.10.20220124
* Fixed some minor issues

## 3.3.9.20220121
* Fixed the bug that the project manager project cannot be expanded in some cases on MacOSX

## 3.3.5.20211229
* Fixed some minor issues

## 3.3.4.20211228
* Fixed some minor issues

## 3.3.3.20211225
* Adjust the UI of the new project window [Details](https://hx.dcloud.net.cn/Tutorial/project?id=CreateProjectWindows)
* Added project manager view toolbar, added positioning and folding functions [Details](https://hx.dcloud.net.cn/Tutorial/project?id=toolbar)
* Fixed a crash in the editor when Find Symbols by clicking on the search area or the built-in Explorer address bar.
* Fixed the Bug where MacOSX failed to run projects to iOS emulator when the HBuilderX installation path had a space.

## 3.2.16.20211122
* Fixed the bug that the hover code assist the editor to crash

## 3.2.15.20211120
* Added Files larger than 1M in size do not display hover code assist
* Fixed the bug that caused the node process to fail to start when the max-old-space-size configured in the operating system environment variables was too large

## 3.2.12.20211029
* Added HBuilderX plug-in development breakpoint debugging
* Added hover code assist [Details](https://hx.dcloud.net.cn/Tutorial/Language/Overview?id=hover-code-assist)
* Added Terminal supports clicking on the URL to jump to the browser [Details](https://hx.dcloud.net.cn/Tutorial/UserGuide/terminal?id=open-links)
* Fixed the bug that when the terminal input exceeds a certain length, the wrong line is displayed
* Fixed the bug that the editor window exceeds the screen area when creating multiple terminals
* Fixed the bug that the editor bookmarks are lost due to code formatting

## 3.2.9.20210927
* Added HBuilderX supports localized language pack extension [Details](https://github.com/dcloudio/hbuilderx-language-packs)
* Vue3 improvements [Details](https://hx.dcloud.net.cn/Tutorial/Language/vue-next)
* Added Configure whether you receive automatic updates.